/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator;

import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.Keyframes;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.AnimationType;
import lib.toma.animations.api.IAnimation;
import lib.toma.animations.api.IAnimationLoader;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.IKeyframe;
import lib.toma.animations.api.IKeyframeProvider;
import lib.toma.animations.engine.frame.MutableKeyframe;
import lib.toma.animations.engine.screen.animator.AnimationProject;
import lib.toma.animations.engine.screen.animator.AnimatorFrameProvider;
import lib.toma.animations.engine.screen.animator.FrameProviderWrapper;
import lib.toma.animations.engine.serialization.AnimationLoader;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Logger;

public final class Animator {
    private static final Animator INSTANCE = new Animator();
    public static final AnimationType<CustomizableAnimation> ANIMATOR_TYPE = AnimationType.create(new ResourceLocation("animator"), Animator.get()::getAnimation);
    public static final AnimationType<BackgroundAnimation> BACKGROUND_TYPE = AnimationType.create(new ResourceLocation("background"));
    private final File exportDir = new File("./export/providers");
    private final Map<String, FrameProviderWrapper> configurables;
    private AnimationProject project = AnimationProject.createEmpty();

    private Animator() {
        this.configurables = new TreeMap<String, FrameProviderWrapper>(this::compareKeys);
    }

    public static Animator get() {
        return INSTANCE;
    }

    public void refreshUserAnimations() {
        List<String> collect = this.configurables.keySet().stream().filter(s -> !s.contains(":")).collect(Collectors.toList());
        collect.forEach(this.configurables::remove);
        this.loadUserDefinedProviders(this.exportDir(), AnimationEngine.get().loader().getResourceReader());
    }

    public void onAnimationsLoaded(Map<ResourceLocation, IKeyframeProvider> providerMap, IAnimationLoader.ILoader loader) {
        this.configurables.clear();
        this.loadModProviders(providerMap.entrySet());
        this.loadUserDefinedProviders(this.exportDir(), loader);
    }

    public void setUsingProject(AnimationProject project) {
        this.project = project;
        if (project == null) {
            this.project = AnimationProject.createEmpty();
        }
    }

    public AnimationProject getProject() {
        return this.project;
    }

    public Collection<String> getPaths() {
        return this.configurables.keySet();
    }

    public FrameProviderWrapper getWrapper(String path) {
        FrameProviderWrapper wrapper = this.configurables.get(path);
        return wrapper.deepCopy();
    }

    private void loadModProviders(Set<Map.Entry<ResourceLocation, IKeyframeProvider>> set) {
        set.forEach(entry -> {
            String name = ((ResourceLocation)entry.getKey()).toString();
            IKeyframeProvider provider = (IKeyframeProvider)entry.getValue();
            this.configurables.put(name, FrameProviderWrapper.modded(name, provider));
        });
    }

    private void loadUserDefinedProviders(File expDir, IAnimationLoader.ILoader loader) {
        if (!expDir.isDirectory()) {
            return;
        }
        for (File file : expDir.listFiles(this::isValidProviderFile)) {
            this.loadUserDefinedProviderFile(file, loader);
        }
    }

    private void loadUserDefinedProviderFile(File file, IAnimationLoader.ILoader loader) {
        Logger log = AnimationEngine.logger;
        try {
            JsonReader reader = new JsonReader((Reader)new FileReader(file));
            IKeyframeProvider provider = loader.loadResource(reader);
            if (provider == null) {
                throw new JsonSyntaxException("Unable to parse");
            }
            String name = file.getName().replaceFirst("[.][^.]+$", "");
            this.configurables.put(name, FrameProviderWrapper.userCreated(name, file.getParentFile(), provider));
        }
        catch (JsonParseException ex) {
            log.error(AnimationLoader.MARKER, "Exception parsing {} file: {}", (Object)file.getPath(), (Object)ex.getMessage());
        }
        catch (IOException ex) {
            log.fatal(AnimationLoader.MARKER, "Fatal exception ocurred while parsing {} file: {}", (Object)file.getPath(), (Object)ex.getMessage());
        }
    }

    private boolean isValidProviderFile(File pathname) {
        return this.getExtension(pathname.getName()).equals("json");
    }

    private String getExtension(String filename) {
        int index = filename.lastIndexOf(46);
        return index == -1 ? "" : filename.substring(index + 1);
    }

    private File exportDir() {
        if (!this.exportDir.exists()) {
            this.exportDir.mkdirs();
        }
        return this.exportDir;
    }

    private int compareKeys(String s1, String s2) {
        boolean b2;
        if (Objects.equals(s1, s2)) {
            return 0;
        }
        boolean b1 = s1 != null && s1.contains(":");
        boolean bl = b2 = s2 != null && s2.contains(":");
        return s1 != null && s2 != null && b1 == b2 ? s1.compareTo(s2) : (b1 && !b2 ? 1 : -1);
    }

    private CustomizableAnimation getAnimation(PlayerEntity client) {
        return new CustomizableAnimation();
    }

    public static class BackgroundAnimation
    implements IAnimation {
        private final Map<AnimationStage, IKeyframe> map = new IdentityHashMap<AnimationStage, IKeyframe>();

        public BackgroundAnimation(IKeyframeProvider provider) {
            if (!(provider instanceof AnimatorFrameProvider)) {
                provider = new AnimatorFrameProvider(provider);
            }
            AnimatorFrameProvider frameProvider = (AnimatorFrameProvider)provider;
            for (Map.Entry<AnimationStage, List<MutableKeyframe>> entry : frameProvider.getFrames().entrySet()) {
                this.map.put(entry.getKey(), this.mergeKeyframesIntoOne(entry.getValue()));
            }
        }

        @Override
        public void animate(AnimationStage stage, MatrixStack matrixStack, IRenderTypeBuffer typeBuffer, int light, int overlay) {
            IKeyframe keyframe = this.map.get(stage);
            if (keyframe == null) {
                return;
            }
            Keyframes.processFrame(keyframe, 1.0f, matrixStack);
        }

        @Override
        public void gameTick() {
        }

        @Override
        public void renderTick(float deltaRenderTime) {
        }

        @Override
        public boolean hasFinished() {
            IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
            return !pipeline.has(ANIMATOR_TYPE);
        }

        private IKeyframe mergeKeyframesIntoOne(List<? extends IKeyframe> iKeyframes) {
            return MutableKeyframe.fullCopyOf(iKeyframes.get(iKeyframes.size() - 1));
        }
    }

    public static class CustomizableAnimation
    implements IAnimation {
        private final BooleanSupplier isPausedSupp = () -> Animator.get().getProject().getAnimationControl().isPaused();
        private final BooleanSupplier isOnRepeat = () -> Animator.get().getProject().getAnimationControl().isOnRepeat();
        private final AnimatorFrameProvider provider;
        private int totalTicks;
        private int remainingTicks;
        private float progress;
        private float progressO;
        private float progressI;
        private boolean removalMarker;

        public CustomizableAnimation() {
            Animator animator = Animator.get();
            AnimationProject project = animator.getProject();
            this.setTickLength(project.getAnimationControl().getAnimationTime());
            this.provider = project.getFrameControl().getProvider();
        }

        @Override
        public void animate(AnimationStage stage, MatrixStack matrixStack, IRenderTypeBuffer typeBuffer, int light, int overlay) {
            float epO;
            if (this.provider.blocksStageAnimation(stage)) {
                return;
            }
            IKeyframe kf = this.provider.getActualFrame(stage, this.progressI);
            IKeyframe kfO = this.provider.getLastFrame(stage);
            float ep = kf.endpoint();
            float min = ep - (epO = kfO.endpoint());
            float sProgress = min == 0.0f ? 1.0f : (this.progressI - epO) / (ep - epO);
            Keyframes.processFrame(kf, sProgress, matrixStack);
        }

        @Override
        public void renderTick(float deltaRenderTime) {
            float prev = this.progressI;
            if (!this.isPausedSupp.getAsBoolean()) {
                this.progressI = Math.min(this.progressO + (this.progress - this.progressO) * deltaRenderTime, this.provider.getAnimationEnd());
                this.advance(this.progressI, prev);
            }
        }

        @Override
        public void gameTick() {
            if (!this.isPausedSupp.getAsBoolean()) {
                int next = this.remainingTicks - 1;
                boolean canRepeat = this.isOnRepeat.getAsBoolean();
                if (next < 0) {
                    if (canRepeat) {
                        this.resetState();
                    }
                } else {
                    this.remainingTicks = next;
                }
            }
            this.progressO = this.progress;
            this.progress = this.getRawProgress();
        }

        @Override
        public boolean hasFinished() {
            return this.removalMarker;
        }

        public void setProgress(float value) {
            this.progress = value;
            this.progressO = value;
            this.progressI = value;
            this.remainingTicks = this.totalTicks - (int)((float)this.totalTicks * value);
            this.provider.forceProgress(value);
        }

        public void setTickLength(int length) {
            this.totalTicks = length;
            this.remainingTicks = length;
        }

        public float getProgress() {
            return this.progressI;
        }

        public void remove() {
            this.removalMarker = true;
        }

        private void advance(float actual, float old) {
            this.provider.onProgressed(actual, old, this);
        }

        private float getRawProgress() {
            return this.isPausedSupp.getAsBoolean() ? this.progress : 1.0f - (float)this.remainingTicks / (float)this.totalTicks;
        }

        private void resetState() {
            this.remainingTicks = this.totalTicks;
            this.progress = 0.0f;
            this.progressO = 0.0f;
            this.progressI = 0.0f;
            this.provider.forceProgress(0.0f);
        }
    }
}

